#ifndef ODEBOX_H_
#define ODEBOX_H_

#include "IPhysicalBox.h"
#include <ode/ode.h>

namespace PhysicsEngine
{

class ODEBox : public PhysicsEngine::IPhysicalBox
{
public:
	ODEBox();
	ODEBox(dWorldID world, int objectid, Vector3f size, Vector3f position,Vector3f rotation, int materialid, float mass, Vector3f linearvelocity, Vector3f angularvelocity);
	virtual ~ODEBox();
	dGeomID GetGeomId();
	void UpdateData();
	DataBox *GetDataBox();
	dWorldID GetWorldId();
	void SetWorldId(dWorldID world);
	void RotateObject(float axis_x, float axis_y, float axis_z, float angle);
	void SetPhysicalPosition(float posx, float posy, float posz);
	Vector3f GetAngularVelocity();
	Vector3f GetLinearVelocity();
private:
	dGeomID bodyid;
	dWorldID world;	
};

}

#endif /*ODEBOX_H_*/
